Option Explicit
Const scriptName = "Cool Slant Shadow"
Const scriptVer = "1.0.0"

' Revision History

' 1.0.0 - July 26, 2002 - MJM - Inital version.



' Script constants, questions, and error messages.s
Const errNoSelection = "This script requires a text selection."




'Main

Dim errNum
errNum = 0

Dim CreatorApp
Set CreatorApp = WScript.CreateObject("Creator.Application")
'Set CreatorApp = GetObject(,"Creator.Application")

CreatorApp.Visible = True

Dim TextSel
If CreatorApp.Documents.Count = 0 Then
  Call MsgBox(errNoSelection, vbOkonly, scriptName)
  errNum = -1
End If

If errNum = 0 Then
  On Error Resume Next
  Set TextSel = CreatorApp.TextSelection
  errNum = Err.Number
  On Error GoTo 0
  
  If errNum <> 0 Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
  Elseif TextSel.CharacterRuns.Count < 1 Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
    errNum = -1
  Elseif TextSel.Start > TextSel.End Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
    errNum = -1
  End If
End If

' Whew!  User Interface Section Done.
If errNum = 0 Then
  TextSel.Outline = True
  TextSel.Shadow = True

  TextSel.BoldOutset = 5
  TextSel.OutlineWeight = 3
    
  TextSel.ShadowHorizontalOffset = -7
  TextSel.ShadowVerticalOffset = 0
  TextSel.ShadowSkew = 15
  TextSel.ShadowVerticalScale = 100
  TextSel.ShadowOutset = 8
End If




